/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.license;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jtbcore.app.DbAppConfig;
import jtbcore.db.common.SqlConnection;
import jtbcore.license.LicenseResponse;
import jtbcore.model.BaseStringMap;
import jtbcore.util.BooleanUtil;
import jtbcore.util.CacheUtil;
import jtbcore.util.RequestUrl;

public class LicenseHandler {
    protected SqlConnection con = null;
    protected String message;
    protected String userMessage;
    protected boolean allowUsage = false;
    protected Boolean validLicense = null;

    public LicenseHandler() {
    }

    public LicenseHandler(SqlConnection con) {
        this.con = con;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public void setUserMessage(String userMessage) {
        this.userMessage = userMessage;
    }

    public boolean hasUserMessage() {
        return this.userMessage != null && this.userMessage.trim().length() > 0;
    }

    public Boolean validLicense() {
        return this.validLicense;
    }

    public boolean allowUsage(DbAppConfig appConfig) {
        try {
            return this.allowUsage(appConfig, appConfig.getLicenseCode());
        }
        catch (Exception ex) {
            System.err.println("Error: LicenseHandler, " + ex.getClass().getSimpleName() + ": " + ex.getMessage());
            return true;
        }
    }

    public boolean allowUsage(DbAppConfig appConfig, String licenseCode) throws SQLException, IOException {
        this.allowUsage = false;
        long timeUsage = System.currentTimeMillis() - appConfig.getAppInitTime();
        long usageSeconds = timeUsage / 1000L;
        if (usageSeconds < 2592000L) {
            this.allowUsage = true;
        }
        this.checkLicense(appConfig, licenseCode);
        if (this.validLicense.booleanValue()) {
            this.allowUsage = true;
        } else {
            this.message = "No license, please register. See www.itxplain.nl";
        }
        return this.allowUsage;
    }

    public boolean checkLicense(DbAppConfig appConfig) throws SQLException {
        return this.checkLicense(appConfig, appConfig.getLicenseCode());
    }

    public boolean checkLicense(DbAppConfig appConfig, String licenseCode) {
        this.validLicense = false;
        LicenseResponse lr_cache = (LicenseResponse)CacheUtil.getCache("licenseResponse");
        if (lr_cache != null && lr_cache.licenseCode != null && lr_cache.licenseCode.equals(licenseCode)) {
            this.validLicense = lr_cache.validLicense;
            this.message = lr_cache.message;
            return lr_cache.validLicense;
        }
        try {
            String uid = appConfig.getAppUid();
            RequestUrl u = new RequestUrl("https://tsgateway.itxplain.nl/license/");
            u.setRequestParam("appName", appConfig.getAppName());
            u.setRequestParam("uid", uid);
            u.setRequestParam("licenseCode", licenseCode);
            u.setRequestParam("appInitTime", Long.toString(appConfig.getAppInitTime()));
            u.setRequestParam("appVersion", Integer.toString(appConfig.getAppVersion()));
            u.setRequestParam("usersReport", this.getUsersReport());
            u.post();
            ObjectMapper om = new ObjectMapper();
            JsonNode jn = om.readTree(u.getResponseData());
            if (jn.get("success").asBoolean()) {
                this.validLicense = true;
                this.message = jn.has("message") ? jn.get("message").asText() : "OK";
            } else if (jn.get("error").asBoolean()) {
                this.validLicense = false;
                this.message = jn.get("message").asText();
            }
            if (jn.has("userMessage")) {
                this.userMessage = jn.get("userMessage").asText();
            }
            if (jn.has("allowUsage") && BooleanUtil.isFalse(jn.get("allowUsage").asText()).booleanValue()) {
                this.allowUsage = false;
            }
            LicenseResponse lr = new LicenseResponse(licenseCode, this.validLicense, this.message);
            CacheUtil.setCache("licenseResponse", lr, 3600);
            return this.validLicense;
        }
        catch (Exception ex) {
            if (ex instanceof UnknownHostException) {
                System.err.println("Error: LicenseHandler.checkLicense(): UnknownHostException: " + ex.getMessage());
            } else {
                System.err.println("Error: LicenseHandler.checkLicense()");
                ex.printStackTrace();
            }
            this.message = "Error: " + ex.getMessage();
            this.allowUsage = true;
            this.validLicense = false;
            return false;
        }
    }

    public String getUsersReport() {
        String s = null;
        if (this.con == null) {
            return null;
        }
        try {
            if (!this.con.getSqlDatabase().hasTable("base__user_log")) {
                return null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            List<BaseStringMap> recs = this.con.queryBsmList("select * from base__user_log", new Object[0]);
            ArrayList result = new ArrayList();
            for (BaseStringMap rec : recs) {
                HashMap<String, Comparable<Integer>> map_user = new HashMap<String, Comparable<Integer>>();
                map_user.put("user_id", rec.getPropertyInt("user_id"));
                map_user.put("created", rec.getPropertyDateTime("created"));
                map_user.put("deleted", rec.getPropertyDateTime("deleted"));
                result.add(map_user);
            }
            ObjectMapper om = new ObjectMapper();
            s = om.writeValueAsString(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return s;
    }

    public static void main(String[] args) {
    }
}

